//
//  PlaygroundContext.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

import UIKit
import SPCLiveView
import Canvas

var lvc = CanvasLiveViewController(context: PlaygroundContext.shared)

/// A struct that configures the Playground and Canvas
///
public struct PlaygroundContext : PlaygroundContextProtocol {
    public static var shared: PlaygroundContextProtocol = PlaygroundContext()
    
    /// Root view controller for the live view
    ///
    public static var liveViewController: LiveViewController = lvc
    
    /// Configures the presentation style of the live view
    ///
    public var presentationMode: LiveViewContentPresentation = .aspectFitMinimum
    
    /// TBD
    ///
    public var proxyClasses: [LiveViewRegistering.Type] = []
    
    /// Capabilities that the playground book should adopt
    ///
    public var capabilities: [PlaygroundCapabilities] = [ .backgroundMusic ]
}


